<?php

function convert_number_to_words($number) {
   
    $hyphen      = '-';
    $conjunction = ' and ';
    $separator   = ', ';
    $negative    = 'negative ';
    $decimal     = ' point ';
    $dictionary  = array(
        0                   => 'zero',
        1                   => 'one',
        2                   => 'two',
        3                   => 'three',
        4                   => 'four',
        5                   => 'five',
        6                   => 'six',
        7                   => 'seven',
        8                   => 'eight',
        9                   => 'nine',
        10                  => 'ten',
        11                  => 'eleven',
        12                  => 'twelve',
        13                  => 'thirteen',
        14                  => 'fourteen',
        15                  => 'fifteen',
        16                  => 'sixteen',
        17                  => 'seventeen',
        18                  => 'eighteen',
        19                  => 'nineteen',
        20                  => 'twenty',
        30                  => 'thirty',
        40                  => 'fourty',
        50                  => 'fifty',
        60                  => 'sixty',
        70                  => 'seventy',
        80                  => 'eighty',
        90                  => 'ninety',
        100                 => 'hundred',
        1000                => 'thousand',
        1000000             => 'million',
        1000000000          => 'billion',
        1000000000000       => 'trillion',
        1000000000000000    => 'quadrillion',
        1000000000000000000 => 'quintillion'
    );
   
    if (!is_numeric($number)) {
        return false;
    }
   
    if (($number >= 0 && (int) $number < 0) || (int) $number < 0 - PHP_INT_MAX) {
        // overflow
        trigger_error(
            'convert_number_to_words only accepts numbers between -' . PHP_INT_MAX . ' and ' . PHP_INT_MAX,
            E_USER_WARNING
        );
        return false;
    }

    if ($number < 0) {
        return $negative . convert_number_to_words(abs($number));
    }
   
    $string = $fraction = null;
   
    if (strpos($number, '.') !== false) {
        list($number, $fraction) = explode('.', $number);
    }
   
    switch (true) {
        case $number < 21:
            $string = $dictionary[$number];
            break;
        case $number < 100:
            $tens   = ((int) ($number / 10)) * 10;
            $units  = $number % 10;
            $string = $dictionary[$tens];
            if ($units) {
                $string .= $hyphen . $dictionary[$units];
            }
            break;
        case $number < 1000:
            $hundreds  = $number / 100;
            $remainder = $number % 100;
            $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
            if ($remainder) {
                $string .= $conjunction . convert_number_to_words($remainder);
            }
            break;
        default:
            $baseUnit = pow(1000, floor(log($number, 1000)));
            $numBaseUnits = (int) ($number / $baseUnit);
            $remainder = $number % $baseUnit;
            $string = convert_number_to_words($numBaseUnits) . ' ' . $dictionary[$baseUnit];
            if ($remainder) {
                $string .= $remainder < 100 ? $conjunction : $separator;
                $string .= convert_number_to_words($remainder);
            }
            break;
    }
   
    if (null !== $fraction && is_numeric($fraction)) {
        $string .= $decimal;
        $words = array();
        foreach (str_split((string) $fraction) as $number) {
            $words[] = $dictionary[$number];
        }
        $string .= implode(' ', $words);
    }
   
    return $string;
}

//This function changes a cardinal number into an ordinal word, but only up to number 20
function ordword($num) {
	$num = intval($num);
	if ($num < 1 || $num > 20 || !is_int($num)){
			trigger_error(
				'ordword only accepts integers between 1 and 20',
				E_USER_WARNING
			);
			return false;
	}
	switch ($num) {
		case 1: 
		return "first";
		case 2: 
		return "second";
		case 3: 
		return "third";
		case 4: 
		return "fourth";
		case 5: 
		return "fifth";
		case 6: 
		return "sixth";
		case 7: 
		return "seventh";
		case 8: 
		return "eighth";
		case 9: 
		return "ninth";
		case 10: 
		return "tenth";
		case 11: 
		return "eleventh";
		case 12: 
		return "twelth";
		case 13: 
		return "thirteenth";
		case 14: 
		return "fourteenth";
		case 15: 
		return "fifteenth";
		case 16: 
		return "sixteenth";
		case 17: 
		return "seventeenth";
		case 18: 
		return "eighteenth";
		case 19: 
		return "nineteenth";
		case 20: 
		return "twentieth";
	}
}

//this function is used to make the continuous inputs
//it requires six images in the images directory
function continuous_scale($inputname,$lefttext="strongly dislike", $righttext="strongly like", $min=0,$max=100) {
global $CFG;
	echo "<table width=380>";
	echo "<tr><td align=left>$lefttext</td><td align=right>$righttext</td></tr>\n";
	echo "<tr><td colspan=2 align=center>";
	for ($i = $min; $i <= $max; $i++) {
		echo "<img src='".$CFG['web_root']."images/";
		if ($i == $min) {
		echo "left.gif";
		} else if ($i == $max) {
		echo "right.gif";
		} else {
		echo "middle.gif";
		}
		echo "' width=3 height=21 name='pic-".$inputname."-$i' onClick='setcontinuous(\"$inputname\",$i,$min,$max)' style='cursor:pointer;' />";
	}
	echo "</td></tr>\n";
	echo "<input type=hidden name='$inputname' value='' />";
	echo "</table>";
}

//this function is used to make a continuous input with a clear center mark
//it requires eight images in the images directory
function continuous_scaleC($inputname,$lefttext="strongly dislike the<br>feeling of waiting", $righttext="strongly like the<br>feeling of waiting", $centertext="neutral", $min=-100,$max=100) {
global $CFG;
	echo "<table width=660>";
	echo "<tr><td align=left width='33%'>$lefttext</td><td align=center width='33%'>$centertext</td><td align=right width='33%'>$righttext</td></tr>";
	echo "<tr><td colspan=3 align=center>";
	for ($i = $min; $i <= $max; $i++) {
		echo "<img src='".$CFG['web_root']."images/";
		if ($i == $min) {
		echo "left.gif";
		} else if ($i == $max) {
		echo "right.gif";
		} else if ($i == 0) {
		echo "center.gif";
		} else {
		echo "middle.gif";
		}
		echo "' name='pic-".$inputname."-$i' onClick='setcontinuousC(\"$inputname\",$i,$min,$max)' style='cursor:pointer;'>";
	}
	echo "</td></tr>";
	echo "<input type=hidden name='$inputname' value='' />";
	echo "</table>\n";
}

//this function is used to make the continuous inputs
//it requires six images in the images directory
function continuous_scaleF($inputname,$lefttext="strongly dislike", $righttext="strongly like", $min=0,$max=270) {
global $CFG;
	echo "<table width=850>";
	echo "<tr><td colspan=2 align=center>";
	for ($i = $min; $i <= $max; $i++) {
		echo "<img src='".$CFG['web_root']."images/";
		if ($i == $min) {
		echo "left.gif";
		} else if ($i == $max) {
		echo "right.gif";
		} else {
		echo "middle.gif";
		}
		echo "' width=3 height=21 name='pic-".$inputname."-$i' onClick='setcontinuous(\"$inputname\",$i,$min,$max)' style='cursor:pointer;' />";
	}
	echo "</td></tr>\n";
	echo "<tr><td align=left>$lefttext</td><td align=right>$righttext</td></tr>\n";
	echo "<input type=hidden name='$inputname' value='' />";
	echo "</table>";
}

//shuffle for associative arrays, preserves key=>value pairs.
//(Based on (Vladimir Kornea of typetango.com)'s function) 
function shuffle_assoc(&$array) {
        $keys = array_keys($array);

        shuffle($keys);

        foreach($keys as $key) {
            $new[$key] = $array[$key];
        }

        $array = $new;

        return true;
    }

?>