<?php

session_start();

// always modified
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");

//set up basic functionality: config, db, functions, classes...
require "config.inc.php";
require $CFG['doc_root']."/classes/class.FormBuilder.php";
include $CFG['doc_root']."/includes/db_connect.inc.php";
include $CFG['doc_root']."/includes/functions.inc.php";

//make sure they are secure
if ($CFG["require_https"] == true && $_SERVER['HTTPS'] != true) {
header("Location: https://".$_SERVER['HTTP_HOST'].$_SERVER["REQUEST_URI"]);
exit;
}

//save and clean any post vars
foreach ($_POST as $key => $value) {
	$_SESSION['form_data'][$key] = $value;
	if (!get_magic_quotes_gpc()) {
		if (is_array($_POST[$key])) {
			foreach ($value as $key2 => $value2) {
			$_POST[$key][$key2] = addslashes($value2);
			}
		} else {
		$_POST[$key] = addslashes($value);
		}
	}
}

//detect old browsers
$unsupported_browsers = array("msie 5","msie 4","msie 3","netscape 5","netscape 4","netscape 3");
foreach ($unsupported_browsers as $browser) {
	if (strpos(strtolower($_SERVER['HTTP_USER_AGENT']), $browser) !== false) { 
	header("Location: oldbrowser.php");
	exit;
	}
}
//detect Safari
if (strpos(strtolower($_SERVER['HTTP_USER_AGENT']), "safari") !== false) {
$using_safari = true;
} else {
$using_safari = false;
}

if (isset($_GET['pid'])) {
	$pid = $_GET['pid'];
	$_SESSION['pid'] = $pid;
} else if (isset($_SESSION['pid'])) {
	$pid = $_SESSION['pid'];
}

//be sure they have a unique ID
if (!isset($_SESSION['pid'])|| !is_numeric($_SESSION['pid']) || $_SESSION['pid'] < 1  || isset($restart_session)) {
	$make_new_record = true;
		
	if ($make_new_record == true) {
	$sql = "insert into participants set p_ip='$_SERVER[REMOTE_ADDR]', p_dateadded=now(), p_serverinfo=\"".addslashes(serialize($_SERVER))."\", p_experiment_num='".$CFG['experiment_num']."'";
	$db->query($sql);
	//and save the new ID in a session var
	$_SESSION['pid'] = $db->insert_id;
	$pid = $_SESSION['pid'];
	}
	
}



if (!isset($_SESSION['timestart'])) {
$_SESSION['timestart'] = time();
}

//update the timing
$totaltime = time() - $_SESSION['timestart'];
$sql = "update participants set p_datestop=now(), p_totaltime = $totaltime where p_id=".$_SESSION['pid'];
$db->query($sql);

?>